/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.number;

import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Matcher;
import org.hamcrest.number.IsCloseTo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsCloseToTest
extends AbstractMatcherTest {
    @Override
    protected Matcher<?> createMatcher() {
        double irrelevant = 0.1;
        return IsCloseTo.closeTo((double)irrelevant, (double)irrelevant);
    }

    public void testEvaluatesToTrueIfArgumentIsEqualToADoubleValueWithinSomeError() {
        Matcher p = IsCloseTo.closeTo((double)1.0, (double)0.5);
        IsCloseToTest.assertTrue((boolean)p.matches((Object)1.0));
        IsCloseToTest.assertTrue((boolean)p.matches((Object)0.5));
        IsCloseToTest.assertTrue((boolean)p.matches((Object)1.5));
        IsCloseToTest.assertDoesNotMatch("too large", p, 2.0);
        IsCloseToTest.assertMismatchDescription("<2.0> differed by <0.5>", p, 2.0);
        IsCloseToTest.assertDoesNotMatch("number too small", p, 0.0);
        IsCloseToTest.assertMismatchDescription("<0.0> differed by <0.5>", p, 0.0);
    }
}

